import { makeStyles } from '@material-ui/core/styles';
import { GREYISH_BROWN } from 'constants/colors';

const useStyles = makeStyles(() => ({
    modalContainer: {
        width: 470,
        position: 'absolute',
        transform: 'translate(-50%, -50%)',
        top: '50%',
        left: '50%',
        boxShadow:
            '0 11px 15px -7px rgba(0, 0, 0, 0.2), 0 9px 46px 8px rgba(0, 0, 0, 0.12), 0 24px 38px 3px rgba(0, 0, 0, 0.14)',
        backgroundColor: '#fafafa',
        display: 'flex',
        flexDirection: 'column',
        padding: '30px 30px 24px',
        boxSizing: 'border-box'
    },
    modalTitle: {
        fontFamily: 'Roboto-Condensed',
        fontWeight: 'bold',
        fontSize: 22,
        color: GREYISH_BROWN
    },
    modalDescription: {
        marginTop: 20,
        fontSize: 16,
        fontFamily: 'Lato',
        lineHeight: '1.27',
        letterSpacing: '0.68px',
        color: GREYISH_BROWN
    },
    modalButtonContainer: {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'flex-end',
        marginTop: 35
    },
    cancelButton: {
        marginLeft: 16
    },
    warningIcon: {
        verticalAlign: 'middle',
        paddingRight: 10
    }
}));

export default useStyles;
